# Источники адресов контрактов токенов

## 1. CoinGecko API (Рекомендуется) ⭐
**URL:** https://api.coingecko.com/api/v3/coins/{coin_id}

**Пример запроса:**
```bash
# Получить все данные о POL (Polygon)
curl "https://api.coingecko.com/api/v3/coins/polygon"

# Ответ будет содержать адреса контрактов для разных сетей:
{
  "platforms": {
    "polygon-pos": "0x0000000000000000000000000000000000001010",
    "ethereum": "0x7d1afa7b718fb893db30a3abc0cfc608aacfebb0"
  }
}
```

**Endpoint для получения списка популярных токенов:**
```bash
curl "https://api.coingecko.com/api/v3/coins/markets?vs_currency=usd&order=market_cap_desc&per_page=100&page=1"
```

**Документация:** https://www.coingecko.com/api/documentations/v3

---

## 2. CoinMarketCap API
**URL:** https://coinmarketcap.com/api/documentation/v1

**Пример запроса:**
```bash
# Получить информацию о токене по ID
curl -H "X-CMC_PRO_API_KEY: YOUR_API_KEY" \
  "https://pro-api.coinmarketcap.com/v1/cryptocurrency/info?id=3890"  # Polygon
```

**Документация:** https://coinmarketcap.com/api/documentation/v1

---

## 3. Сканеры блокчейнов

### PolygonScan (Polygon)
**URL:** https://polygonscan.com/tokens

**API Endpoint:**
```bash
# Получить топ токенов по holders
curl "https://api.polygonscan.com/api?module=token&action=tokentx&contractaddress=0x...&startblock=0&endblock=99999999&sort=asc&apikey=YOUR_API_KEY"
```

**Документация:** https://docs.polygonscan.com/api-endpoints/tokens

### Etherscan (Ethereum)
**URL:** https://etherscan.io/tokens

**API Endpoint:**
```bash
curl "https://api.etherscan.com/api?module=token&action=tokentx&contractaddress=0x...&apikey=YOUR_API_KEY"
```

**Документация:** https://docs.etherscan.io/api-endpoints/tokens

### BSCScan (BSC)
**URL:** https://bscscan.com/tokens

**API Endpoint:**
```bash
curl "https://api.bscscan.com/api?module=token&action=tokentx&contractaddress=0x...&apikey=YOUR_API_KEY"
```

---

## 4. DEX Aggregators

### 0x Protocol
**URL:** https://0x.org/

**API для получения списка токенов:**
```bash
# Получить список токенов для сети
curl "https://api.0x.org/token-metadata/v1/tokens?chainId=137"
```

**Документация:** https://docs.0x.org/0x-api-swap/api-references

### Uniswap
**URL:** https://uniswap.org/

**GraphQL Endpoint:**
```graphql
{
  tokens(
    first: 100
    orderBy: totalValueLockedUSD
    orderDirection: desc
  ) {
    id
    symbol
    name
  }
}
```

---

## 5. DeFi Llama
**URL:** https://defillama.com/docs/api

**Пример запроса:**
```bash
# Получить список токенов для сети
curl "https://coins.llama.fi/chains?includePrices=true"
```

---

## 6. Готовые списки (GitHub)

### Официальные стандарты токенов
- **ERC-20 список:** https://github.com/MyEtherWallet/ethereum-lists
- **Token Lists:** https://tokenlists.org/

### Популярные репозитории
1. **Uniswap Token Lists:** https://github.com/uniswap/token-lists
2. **Yearn Token List:** https://github.com/yearn/yearn-assets
3. **Polygon Token List:** https://github.com/maticnetwork/polygon-token-list

**Пример использования:**
```bash
# Скачать официальный список токенов Polygon
curl "https://unpkg.com/@uniswap/default-token-list@latest/build/uniswap-default.tokenlist.json"
```

---

## 7. Онлайн источники

### Token Lists
**URL:** https://tokenlists.org/

Содержит агрегированные списки токенов от различных проектов.

### CryptoCompare
**URL:** https://www.cryptocompare.com/api/

**Пример:**
```bash
curl "https://min-api.cryptocompare.com/data/blockchain/list?api_key=YOUR_API_KEY"
```

---

## Рекомендуемый подход

1. **Для начала:** Используйте CoinGecko API (бесплатный, без ключа)
2. **Для валидации:** Проверьте адреса через блокчейн-сканеры
3. **Для актуальности:** Периодически обновляйте список токенов через DEX агрегаторы

---

## Пример Python кода для получения адресов

```python
import requests

def get_token_addresses(symbols, network='polygon'):
    """Получает адреса контрактов токенов из CoinGecko"""
    addresses = {}
    
    for symbol in symbols:
        # Получаем данные токена
        url = f"https://api.coingecko.com/api/v3/coins/{symbol}"
        response = requests.get(url)
        
        if response.status_code == 200:
            data = response.json()
            # Извлекаем адрес для нужной сети
            if 'platforms' in data:
                network_map = {
                    'polygon': 'polygon-pos',
                    'ethereum': 'ethereum',
                    'bsc': 'binance-smart-chain'
                }
                platform_key = network_map.get(network)
                if platform_key in data['platforms']:
                    addresses[symbol] = data['platforms'][platform_key]
    
    return addresses
```

