# 🪙 Работа с адресами токенов

## 📚 Документация

Полная документация по источникам адресов токенов находится в файле:
**`resources/token_sources.md`**

## 🚀 Использование скрипта

### Запуск скрипта получения адресов

```bash
cd "/home/maxport/Рабочий стол/AI cursor"
source .venv/bin/activate
python scripts/fetch_token_addresses.py
```

Скрипт:
1. Получит адреса токенов из CoinGecko API
2. Добавит известные адреса из Polygonscan
3. Сгенерирует Python код
4. Сохранит результат в `token_addresses_polygon.py`

## 📋 Основные источники

### 1. CoinGecko API ⭐ (Бесплатный, без ключа)
- **URL:** https://api.coingecko.com/api/v3/coins/{coin_id}
- **Преимущества:**
  - Бесплатно
  - Не требует API ключа
  - Поддерживает все сети
  - Актуальные данные
- **Недостатки:** Rate limit (30 запросов/минуту)

### 2. Polygonscan
- **URL:** https://polygonscan.com/tokens
- **Использование:** Для валидации и ручной проверки адресов

### 3. Ethereum Lists (GitHub)
- **URL:** https://github.com/ethereum-lists/tokens
- **Использование:** Готовые JSON файлы с адресами токенов

## 🔧 Интеграция с проектом

После получения адресов через скрипт:

1. Откройте файл `token_addresses_polygon.py`
2. Скопируйте словарь `token_addresses`
3. Вставьте в `plugins/balance_manager_standalone.py` в методе `_get_token_contracts_for_network`

## 📊 Пример результата

```python
# Адреса токенов для polygon
token_addresses = {
    "1INCH": "0x111111111117dC0aa78b770fA6A738034120C302",
    "AAVE": "0xD6DF932A45C0f255f85145f286eA0b292B21C90B",
    "BAL": "0x9a71012B13CA4d3D0CdC72A177DF3ef03b0E76A3",
    "COMP": "0x8505b9d2254A7Ae468c0E9dd10Cce3Eec8741c87",
    "CRV": "0x172370d5Cd63279eFa6d502DAB29171933a610AF",
    "DAI": "0x8f3Cf7ad23Cd3CaDbD9735AFf958023239c6A063",
    ...
}
```

## ⚠️ Важные заметки

1. **Rate Limits:**
   - CoinGecko: 30 запросов/минуту (без ключа)
   - Можно добавить задержку в скрипте

2. **Проверка адресов:**
   - Всегда проверяйте адреса через block explorer
   - Убедитесь, что адрес соответствует правильной сети

3. **Обновление:**
   - Токены могут мигрировать на новые контракты
   - Периодически обновляйте список адресов

## 🎯 Быстрый старт

```bash
# 1. Запустить скрипт
python scripts/fetch_token_addresses.py

# 2. Посмотреть результат
cat token_addresses_polygon.py

# 3. Скопировать адреса в баланс-менеджер
# Вручную или автоматизировать через sed/awk
```

## 📞 Проблемы и решения

**Ошибка: Rate limit exceeded**
- Решение: Подождите 1 минуту или получите бесплатный API ключ на CoinGecko

**Ошибка: Token not found**
- Решение: Проверьте правильность символа в `coingecko_ids` в скрипте

**Ошибка: Address not found for network**
- Решение: Токен может не поддерживать эту сеть. Пропустите или добавьте вручную

