"""
Синхронное получение цен токенов для Function Calling
"""

def fetch_prices_sync(symbols: list) -> dict:
    """
    Синхронно получает цены токенов в USD
    
    Args:
        symbols: Список символов токенов (например, ['POL', 'USDT'])
        
    Returns:
        dict: {symbol: price_usd}
    """
    try:
        from plugins.token_price_service import TokenPriceService
        
        price_service = TokenPriceService()
        prices = {}
        
        for symbol in symbols:
            try:
                price = price_service.get_token_price(symbol, 'usd')
                if price:
                    prices[symbol] = price
                    print(f"💵 {symbol}: ${price:.4f}")
            except Exception as e:
                print(f"⚠️ Не удалось получить цену для {symbol}: {e}")
                
        return prices
        
    except Exception as e:
        print(f"❌ Ошибка получения цен: {e}")
        return {}

